#include <map>
//#include <chrono>
//#include <thread>


#define RAD2DEG( x )  ( (float)(x) * (float)(180.f / IM_PI) )
#define DEG2RAD( x ) ( (float)(x) * (float)(IM_PI / 180.f) )


static inline ImVec2  operator*(const ImVec2& lhs, const float rhs) { return ImVec2(lhs.x * rhs, lhs.y * rhs); }
static inline ImVec2  operator/(const ImVec2& lhs, const float rhs) { return ImVec2(lhs.x / rhs, lhs.y / rhs); }
static inline ImVec2  operator+(const ImVec2& lhs, const float rhs) { return ImVec2(lhs.x + rhs, lhs.y + rhs); }
static inline ImVec2  operator+(const ImVec2& lhs, const ImVec2& rhs) { return ImVec2(lhs.x + rhs.x, lhs.y + rhs.y); }
static inline ImVec2  operator-(const ImVec2& lhs, const ImVec2& rhs) { return ImVec2(lhs.x - rhs.x, lhs.y - rhs.y); }
static inline ImVec2  operator-(const ImVec2& lhs, const float rhs) { return ImVec2(lhs.x - rhs, lhs.y - rhs); }
static inline ImVec2  operator*(const ImVec2& lhs, const ImVec2& rhs) { return ImVec2(lhs.x * rhs.x, lhs.y * rhs.y); }
static inline ImVec2  operator/(const ImVec2& lhs, const ImVec2& rhs) { return ImVec2(lhs.x / rhs.x, lhs.y / rhs.y); }
static inline ImVec2& operator*=(ImVec2& lhs, const float rhs) { lhs.x *= rhs; lhs.y *= rhs; return lhs; }
static inline ImVec2& operator/=(ImVec2& lhs, const float rhs) { lhs.x /= rhs; lhs.y /= rhs; return lhs; }
static inline ImVec2& operator+=(ImVec2& lhs, const ImVec2& rhs) { lhs.x += rhs.x; lhs.y += rhs.y; return lhs; }
static inline ImVec2& operator-=(ImVec2& lhs, const ImVec2& rhs) { lhs.x -= rhs.x; lhs.y -= rhs.y; return lhs; }
static inline ImVec2& operator*=(ImVec2& lhs, const ImVec2& rhs) { lhs.x *= rhs.x; lhs.y *= rhs.y; return lhs; }
static inline ImVec2& operator/=(ImVec2& lhs, const ImVec2& rhs) { lhs.x /= rhs.x; lhs.y /= rhs.y; return lhs; }
static inline ImVec4  operator+(const ImVec4& lhs, const ImVec4& rhs) { return ImVec4(lhs.x + rhs.x, lhs.y + rhs.y, lhs.z + rhs.z, lhs.w + rhs.w); }
static inline ImVec4  operator-(const ImVec4& lhs, const ImVec4& rhs) { return ImVec4(lhs.x - rhs.x, lhs.y - rhs.y, lhs.z - rhs.z, lhs.w - rhs.w); }
static inline ImVec4  operator*(const ImVec4& lhs, const ImVec4& rhs) { return ImVec4(lhs.x * rhs.x, lhs.y * rhs.y, lhs.z * rhs.z, lhs.w * rhs.w); }
inline float colorVisible[4] = { 0.0f, 1.0f, 0.0f, 1.0f }; 
inline float colorInvisible[4] = { 1.0f, 0.0f, 0.0f, 1.0f }; 

template <typename T>
inline T clamp1(const T& n, const T& lower, const T& upper) { 
    return std::max(lower, std::min(n, upper));
}

inline float lerp(float a, float b, float f) {
	return clamp1<float>(a + f * (b - a),a > b ? b : a,a > b ? a : b);
}

#pragma once

#define ARGB(a, r, g, b) 0 | a << 24 | r << 16 | g << 8 | b

float Rainbow() {
	static float x = 0, y = 0;
	static float r = 0, g = 0, b = 0;
	if (y >= 0.0f && y < 255.0f) {
		r = 255.0f;
		g = 0.0f;
		b = x;
	} else if (y >= 255.0f && y < 510.0f) {
		r = 255.0f - x;
		g = 0.0f;
		b = 255.0f;
	} else if (y >= 510.0f && y < 765.0f) {
		r = 0.0f;
		g = x;
		b = 255.0f;
	} else if (y >= 765.0f && y < 1020.0f) {
		r = 0.0f;
		g = 255.0f;
		b = 255.0f - x;
	} else if (y >= 1020.0f && y < 1275.0f) {
		r = x;
		g = 255.0f;
		b = 0.0f;
	} else if (y >= 1275.0f && y < 1530.0f) {
		r = 255.0f;
		g = 255.0f - x;
		b = 0.0f;
	}
	x+= 0.25f; 
	if (x >= 255.0f)
		x = 0.0f;
	y+= 0.25f;
	if (y > 1530.0f)
		y = 0.0f;
	return ARGB(255, (int)r, (int)g, (int)b);
}


ImColor GetHealthColor (float health, float maxHp = 100.0f)
{
    float r = std::min(519 * (maxHp - health) / maxHp, 255.0f);
    float g = std::min(510 * health / maxHp, 255.0f); 
    return ImVec4(r/ 255.0f, g / 255.0f, 0.f, 1.0f);
}

bool isOutsideScreen(ImVec2 pos, ImVec2 screen) {
    if (pos.y < 0) {
        return true;
    }
    if (pos.x > screen.x) {
        return true;
    }
    if (pos.y > screen.y) {
        return true;
    }
    return pos.x < 0;
}

Vector3 add(Vector3 v1, Vector3 v2) {
    return Vector3(v1.x + v2.x, v1.y + v2.y, v1.z + v2.z);
}

ImVec2 pushToScreenBorder(ImVec2 Pos, ImVec2 screen, int offset) {
    int x = (int) Pos.x;
    int y = (int) Pos.y;
    
    if (Pos.y < 0) {
        y = -offset;
    }
    
    if (Pos.x > screen.x) {
        x = (int) screen.x + offset;
    }
    
    if (Pos.y > screen.y) {
        y = (int) screen.y + offset;
    }
    
    if (Pos.x < 0) {
        x = -offset;
    }
    return ImVec2(x, y);
}

void DrawBox(float X, float Y, float W, float H, ImColor Color, float curve, float thickness)
{
    W *= 0.95f;
    H *= 0.95f;

    float offsetX = (1.0f - 0.95f) * W / 2.0f;
    float offsetY = (1.0f - 0.95f) * H / 2.0f;

    X += offsetX;
    Y += offsetY;

    ImDrawList* draw_list = ImGui::GetForegroundDrawList();

    ImColor fillColor = ImColor(255, 255, 255, 50); 
    draw_list->AddRectFilled(ImVec2(X, Y), ImVec2(X + W, Y + H), fillColor, curve);

    draw_list->AddRect(ImVec2(X, Y), ImVec2(X + W, Y + H), ImColor(139, 0, 0), curve, 0.001f); 
}

void drawRectFilledWithPos(ImVec2 pos, ImVec2 size, ImColor color)
{
    ImGui::GetBackgroundDrawList()->AddRectFilled(pos, ImVec2(pos.x + size.x, pos.y + size.y), color, 0, 0);
}


void hpasddsfhjdjhsbsd(float hp, float maxHp, float xh, float yh, ImFont* _espFont) 
{
    char textBuffer[64];
    sprintf(textBuffer, ENCRYPT("HP: %.0f/%.0f"), hp, maxHp); 

    float width = _espFont->CalcTextSizeA(_espFont->FontSize, MAXFLOAT, 0.0f, textBuffer).x;
    
    float rate = hp / maxHp;
    
    float height = _espFont->FontSize * 0.25f; 

    float x = xh - width / 2;
    float y = yh + _espFont->FontSize * 0.2f;

    ImColor color = ImColor(0, 255, 0); 
    if (rate < 0.35) {
        color = ImColor(255, 0, 0);
    } else if (rate < 0.75) {
        color = ImColor(255, 165, 0); 
    }

    drawRectFilledWithPos(ImVec2(x, y), ImVec2(width * rate, height), color);
}


void DrawText2(ImFont * _espFont, float fontSize, ImVec2 position, ImColor Color, const char *text, ImColor colorFilled)
{
    ImGui::GetBackgroundDrawList()->AddRectFilled(ImVec2(position.x - 3, position.y - 3), 
                                                  ImVec2(position.x + _espFont->CalcTextSizeA(fontSize, MAXFLOAT, 0.0f, text).x + 3, 
                                                         position.y + 12), colorFilled, 0, 0);
    ImDrawList* draw_list = ImGui::GetForegroundDrawList();
    draw_list->AddText(NULL, fontSize, position, Color, text);
}

void RenderLine(const ImVec2& from, const ImVec2& to, ImColor Color, float thickness)
{
ImDrawList* draw_list = ImGui::GetForegroundDrawList();
draw_list->AddLine(from, to, Color, thickness);
}


static int espActivationCount = 0;
bool ESPEnable = false, ESPLine = true, ESPBox, ESPSkeleton, ESPHealth, ESPL = false, ESPDistance, ESPName, ESPArrow, Crosshair;
float colorEsp[3] = {255, 255, 255};
static int Box = 0;
float AimFov = 0.0f;
bool aimStart, isAimFov, AimScope, AimFire, AimDam, LuonluomAim, line, FSWitch, AimVisible;
static bool AimKill = false;
static int style_idx = 0;
static int AimWhen = 1;
static int AimType = 0;
static bool autotroca = false;
static bool sID = false;
int AimMissel = 1; 
int AimTarget;

int ESPLinePosition = 0;
int ESPBoxShape = 0;     
int ESPNameShadow = 0;   
int ESPHealthPosition = 0;

static int tS = 0;
bool enable_circleFov = false;
int circleSizeValue = 40;
int aim_target = 0;


bool (*Team) (void*player);
int (*maxhealth)(void *player);
void* (*get_camera)();
void* (*get_transform)(void*);
void* ClosestEnemy = nullptr; 
Vector3 (*worldToScreen)(void *cam, Vector3 pos);
Vector3 (*WorldToViewpoint)(void*, Vector3, int);
Vector3 (*get_position)(void*);
ImVec4 color = ImVec4(1.0f, 1.0f, 1.0f, 1.0f);


using namespace std;

class Vvector3 {
public:
    float x;
    float y;
    float z;
    Vvector3() : x(0), y(0), z(0) {}
    Vvector3(float x1, float y1, float z1) : x(x1), y(y1), z(z1) {}
    Vvector3(const Vvector3 &v);
    ~Vvector3();
};
Vvector3::Vvector3(const Vvector3 &v) : x(v.x), y(v.y), z(v.z) {}
Vvector3::~Vvector3() {}


Vector3 getPosition(void *transform) {
    return get_position(get_transform(transform));
} 

Vector3 GetPlayerLocation(void* player) {
    Vector3 location;
    location = get_position(get_transform(player));
    return location;
}

void *(*get_transformFF)(void*inst);

static void *CurentMatch() {
    void *(*_CurentMatch) (void *instance) = (void *(*)(void *))getRealOffset(ENCRYPTOFFSET("0x102933AC8")); // ATUALIZADA 100%
    return _CurentMatch(NULL); // public static NFJPHMKKEBF CurrentMatch() { } 
}

static Vector3 Transform_GetPosition(void *player) {
    Vector3 out = Vector3::zero();
    void (*_Transform_GetPosition)(void *transform, Vector3 * out) = (void (*)(void *, Vector3 *))getRealOffset(ENCRYPTOFFSET("0x106DEAFC4")); // ATUALIZADA 100%
    return out; // (private void get_position_Injected(out Vector3 ret) { })
}

static Vector3 Transform_INTERNAL_GetPosition(void *player) {
    Vector3 out = Vector3::zero();
    void (*_Transform_INTERNAL_GetPosition)(void *transform, Vector3 * out) = (void (*)(void *, Vector3 *))getRealOffset(ENCRYPTOFFSET("0x106DEAFC4")); // ATUALIZADA 100%
    _Transform_INTERNAL_GetPosition(player, &out);
    return out; // private void get_position_Injected(out Vector3 ret) { }
}

static void Transform_INTERNAL_SetPosition(void *player, Vvector3 inn) {
    void (*_Transform_INTERNAL_SetPosition)(void *transform, Vvector3 in) = (void (*)(void *, Vvector3))getRealOffset(ENCRYPTOFFSET("0x106DEB068")); // ATUALIZADA 100%
    _Transform_INTERNAL_SetPosition(player, inn); // private void set_position_Injected(ref Vector3 value) { }
}



bool IsClientBot(void* _this) { return *(bool*)((uint64_t)_this + 0x348); } // ATUALIZADA (public bool IsClientBot;) 100%


static void *GetLocalPlayer(void* Match) {
    void *(*_GetLoalPlayer)(void *match) = (void *(*)(void *))getRealOffset(ENCRYPTOFFSET("0x105146490")); // ATUALIZADO 100%
    return _GetLoalPlayer(Match); // private static Player GetLocalPlayer() { }
}

static void *Current_Local_Player() {
    void *(*_Local_Player)(void *players) = (void *(*)(void *))getRealOffset(ENCRYPTOFFSET("0x102933F98")); // ATUALIZADA 100%
    return _Local_Player(NULL); // public static Player CurrentLocalPlayer() { }
}

static void *GetLocalPlayerOrObServer() 
{
    void *(*_GetLocalPlayerOrObServer)(void *players) = (void *(*)(void *))getRealOffset(ENCRYPTOFFSET("0x102931E40")); // ATUALIZADA 100%
    return _GetLocalPlayerOrObServer(NULL);
}

static void *Camera_main() {
    void *(*_Camera_main)(void *nuls) = (void *(*)(void *))getRealOffset(ENCRYPTOFFSET("0x106DA2D04")); // ATUALIZADO 100%
    return _Camera_main(nullptr);
}

monoString* get_Nickname(void* player) {
    monoString* (*nickname)(void* instance) = (monoString * (*)(void*)) getRealOffset(ENCRYPTOFFSET("0x105EB4C04")); // ATUALIZADA 100%
    return nickname(player);  
}
std::string monoStringToStdString(monoString* mStr) {
    if (mStr == nullptr) return "";
    return std::string(mStr->toCString());
}

std::string getPlayerNickname(void* player) {
    if (player == nullptr) return "";
    monoString* mStr = get_Nickname(player);
    return monoStringToStdString(mStr);
}

Vector3 GetHeadPosition(void* player) {
    void* HeadITF = *(void**)((uintptr_t)player + 0x528); // ATUALIZADO
    void* HeadTF = get_transformFF(HeadITF); //    protected ITransformNode OLCJOGDHJJJ; 
    Vector3 Head = getPosition(HeadTF);
    return Head;
}

Vector3 GetNeckPosition(void* player) {
    Vector3 HeadPos = GetHeadPosition(player);
    Vector3 NeckPos = HeadPos;
    NeckPos.y -= 0.19f; 
    return NeckPos;
}

Vector3 GetPeitoPosition(void* player) {
    Vector3 HeadPos = GetHeadPosition(player);
    Vector3 PeitoPos = HeadPos;
    PeitoPos.y -= 0.35f; 
    return PeitoPos;
}

Vector3 GetHipPosition(void* player) {
    void* HipITF = *(void**)((uintptr_t)player + 0x530); // ATUALIZADO
    void* HipTF = get_transformFF(HipITF); // protected ITransformNode OLJBCONDGLO;
    Vector3 Hip = getPosition(HipTF);
    return Hip;
}

Vector3 GetLeftShoulderPosition(void* player) {
    void* LeftShoulderITF = *(void**)((uintptr_t)player + 0x590); // ATUALIZADO
    void* LeftShoulderTF = get_transformFF(LeftShoulderITF); //    protected ITransformNode LIBEIIIAGIK;
    Vector3 LeftShoulder = getPosition(LeftShoulderTF);
    return LeftShoulder;
}

Vector3 GetRightShoulderPosition(void* player) {
    void* RightShoulderITF = *(void**)((uintptr_t)player + 0x598); // ATUALIZADO
    void* RightShoulderTF = get_transformFF(RightShoulderITF); // protected ITransformNode HDEPJIBNIIK;
    Vector3 RightShoulder = getPosition(RightShoulderTF);
    return RightShoulder;
}

Vector3 GetLeftAnklePosition(void* player) {
    void* LeftAnkleITF = *(void**)((uintptr_t)player + 0x568); // ATUALIZADO
    void* LeftAnkleTF = get_transformFF(LeftAnkleITF); // protected ITransformNode BMGCHFGEDDA;
    Vector3 LeftAnkle = getPosition(LeftAnkleTF);
    return LeftAnkle;
}

Vector3 GetRightAnklePosition(void* player) {
    void* RightAnkleITF = *(void**)((uintptr_t)player + 0x560); // ATUALIZADO
    void* RightAnkleTF = get_transformFF(RightAnkleITF); // protected ITransformNode AGHJLIMNPJA;
    Vector3 RightAnkle = getPosition(RightAnkleTF);
    return RightAnkle;
}

Vector3 GetLeftToePosition(void* player) {
    void* LeftToeITF = *(void**)((uintptr_t)player + 0x578); // ATUALIZADO
    void* LeftToeTF = get_transformFF(LeftToeITF); // protected ITransformNode FDMBKCKMODA;
    Vector3 LeftToe = getPosition(LeftToeTF);
    return LeftToe;
}

Vector3 GetRightToePosition(void* player) {
    void* RightToeITF = *(void**)((uintptr_t)player + 0x570); // ATUALIZADO
    void* RightToeTF = get_transformFF(RightToeITF); // protected ITransformNode CKABHDJDMAP;
    Vector3 RightToe = getPosition(RightToeTF);
    return RightToe;
}

Vector3 GetLeftHandPosition(void* player) {
    void* LeftHandITF = *(void**)((uintptr_t)player + 0x5A8); // ATUALIZADO
    void* LeftHandTF = get_transformFF(LeftHandITF); // protected ITransformNode JHIBMHEMJOL;
    Vector3 LeftHand = getPosition(LeftHandTF);
    return LeftHand;
}

Vector3 GetRightHandPosition(void* player) {
    void* RightHandITF = *(void**)((uintptr_t)player + 0x5A0); // ATUALIZADO
    void* RightHandTF = get_transformFF(RightHandITF);
    Vector3 RightHand = getPosition(RightHandTF); // protected ITransformNode NJDDAPKPILB;
    return RightHand;
}

Vector3 GetRightForeArmPosition(void* player) {
    void* RightForeArmITF = *(void**)((uintptr_t)player + 0x5B0); // ATUALIZADO
    void* RightForeArmTF = get_transformFF(RightForeArmITF); // protected ITransformNode JBACCHNMGNJ;
    Vector3 RightForeArm = getPosition(RightForeArmTF);
    return RightForeArm;
}

Vector3 GetLeftForeArmPosition(void* player) {
    void* LeftForeArmITF = *(void**)((uintptr_t)player + 0x5B8); // ATUALIZADO
    void* LeftForeArmTF = get_transformFF(LeftForeArmITF); // protected ITransformNode FGECMMJKFNC;
    Vector3 LeftForeArm = getPosition(LeftForeArmTF);
    return LeftForeArm;
}

// Vector3 GetToePosition(void* player) {
//     void *ToeITF= *(void **)((uintptr_t) player + 0x4C0); // falta eseeeeeeeee !!
//     void *ToeTF = get_transformFF(ToeITF);
//     Vector3 Toe = getPosition(ToeTF);
//     return Toe;
// }

static bool get_isVisible(void *player) {
    bool (*_get_isVisible)(void *players) = (bool (*)(void *))getRealOffset(ENCRYPTOFFSET("0x105EBCD78")); // ATUALIZADO 100%
    return _get_isVisible(player); // public override bool IsVisible() { }
}

static void *Component_GetTransform(void *player) {
    void *(*_Component_GetTransform)(void *component) = (void *(*)(void *))getRealOffset(ENCRYPTOFFSET("0x106DA4DC0"));  // ATUALIZADO 100%
    return _Component_GetTransform(player); // public Transform get_transform() { }
}

// static void SwapWeapon(void* player, int POFFNNMOOBM, bool GDKLMFLNNGM) {
 //   void (*_SwapWeapon)(void* player, int POFFNNMOOBM, bool GDKLMFLNNGM) = (void (*)(void *, int, bool))getRealOffset(ENCRYPTOFFSET("0x105875044")); // ATUALIZADA 100%
 //    _SwapWeapon(player, POFFNNMOOBM, GDKLMFLNNGM); // public override void SwapWeapon(BMGBKEENCJH FANMJANBFIL, bool GDKLMFLNNGM = False) { }
//}

typedef struct _RayCastHit {
    Vector3 m_Point;
    Vector3 m_Normal;
    int m_FaceID;
    float m_Distance;
    Vector2 m_UV;
    void * collider;
} RayCastHit;

static bool Physics_Raycast(Vector3 camLocation, Vector3 headLocation, unsigned int LayerID, void* collider) {
    bool (*_Physics_Raycast)(Vector3 camLocation, Vector3 headLocation, unsigned int LayerID, void* collider) = (bool(*)(Vector3, Vector3, unsigned int, void*)) getRealOffset(ENCRYPTOFFSET("0x105E83118")); // ATUALIZADO 100%
    return _Physics_Raycast(camLocation, headLocation, LayerID, collider); //public static bool PLDCHDBCOBF(Vector3 OOFIJHADLNI, Vector3 CHGADBAMMOP, uint ONEDHFJBCMJ, ref MADMMIICBNN JEEIBOEGGPD) { }
}

static void *Player_GetHeadCollider(void *player) {
    void *(*_Player_GetHeadCollider)(void *players) = (void *(*)(void *))getRealOffset(ENCRYPTOFFSET("0x105EB7BE4"));// ATUALIZADO 100%
    return _Player_GetHeadCollider(player); // public virtual Collider get_HeadCollider() { }
}

bool IsVisible(void *enemy)  {
    if(enemy != NULL)  {
         void *hitObj = NULL;
         auto Camera = getPosition(Camera_main());
         auto Target = getPosition(Player_GetHeadCollider(enemy));
         return !Physics_Raycast(Camera, Target, 12, &hitObj);
    }
    return false;
}


static bool get_isLocalTeam(void *player) {
    bool (*_get_isLocalTeam)(void *players, bool isCheckSocial3pEffect) = (bool (*)(void *, bool))getRealOffset(ENCRYPTOFFSET("0x105ED1A84")); // ATUALIZADA 100%
    return _get_isLocalTeam(player, false); // public virtual bool IsLocalTeammate() { }
}

static bool get_IsDieing(void *player) {
    bool (*_get_die)(void *players) = (bool (*)(void *))getRealOffset(ENCRYPTOFFSET("0x105EAD858")); // ATUALIZADO 100%
    return _get_die(player); // public bool get_IsDieing() { }
}

static int GetHp(void* player) {
    int (*_GetHp)(void* players) = (int(*)(void *))getRealOffset(ENCRYPTOFFSET("0x105F16EA8")); // ATUALIZADO 100%
    return _GetHp(player); // public int get_CurHP() { }
}

static int get_MaxHP(void* enemy) {
    int (*_get_axHP)(void* player) = (int(*)(void *))getRealOffset(ENCRYPTOFFSET("0x105F16F50")); // ATUALIZADO 100%
    return _get_axHP(enemy); // public int get_MaxHP() { }
}

static bool IsPlayerDead(void* player) {
    if (GetHp(player) < 1) {
        return true;
    }
    return false;
}

bool get_isLiving(void* player) {
    if (GetHp(player) > 0) {
        return true;
    } else {
        return false;
    }
}

static void *IsLocal() {
    void *(*_Local_Player)(void *players) = (void *(*)(void *))getRealOffset(ENCRYPTOFFSET("0x102933F98")); // ATUALIZADO 100%
    return _Local_Player(NULL); // public static Player CurrentLocalPlayer() { }
}

static void *IsLocalObServer() {
    void *(*_GetocalPlayerOrObServer)(void *players) = (void *(*)(void *))getRealOffset(ENCRYPTOFFSET("0x102931E40")); // ATUALIZADO 100%
    return _GetocalPlayerOrObServer(NULL); // public static Player GetLocalPlayerOrObServer() { }
}

static void *get_MyFollowCamera(void *players) {
    void *(*_get_yFollowCamera) (void *player) = (void *(*)(void *))getRealOffset(ENCRYPTOFFSET("0x105EB77C4")); // ATUALIZADO 100%
    return _get_yFollowCamera(players); // public FollowCamera get_MyFollowCamera() { }
}

static Vector3 GetAttackableCenterWS(void *player) {
    Vector3 (*_GtAttackableCenterWS)(void *players) = (Vector3 (*)(void *))getRealOffset(ENCRYPTOFFSET("0x105FE73FC")); // ATUALIZADA 100%
    return _GtAttackableCenterWS(player); // public Vector3 <>iFixBaseProxy_GetAttackableCenterWS() { }
}

Vector3 CameraMain(void* player){
    return getPosition(*(void**) ((uint64_t) player + 0x290)); // ATUALIZADO // (public Transform MainCameraTransform;) 100%
}

static bool get_IsSighting(void *player) {
    bool (*_get_Isighting)(void *players) = (bool (*)(void *))getRealOffset(ENCRYPTOFFSET("0x105EADED0")); // ATUALIZADO 100%
    return _get_Isighting(player);
}
static bool get_IsCrouching(void *player) {
    bool (*_get_IsCrouching)(void *players) = (bool (*)(void *))getRealOffset(ENCRYPTOFFSET("0x105EA75E0")); // ATUALIZADO 100%
    return _get_IsCrouching(player);
}
static bool get_IsFiring(void *player) {
    bool (*_get_IsFiring)(void *players) = (bool (*)(void *))getRealOffset(ENCRYPTOFFSET("0x105EADE1C")); // ATUALIZADO 100%
    return _get_IsFiring(player);
}

static Vector3 GetForward(void *player) {
    Vector3 (*_GetForward)(void *players) = (Vector3 (*)(void *))getRealOffset(ENCRYPTOFFSET("0x106DEB944")); // ATUALIZADO 100%
    return _GetForward(player); // public Vector3 get_forward() { }
}

static void set_aim(void *player, Quaternion look) {
    void (*_set_aim_nepmods)(void *players, Quaternion lock, bool needCount) = (void (*)(void *, Quaternion, bool))getRealOffset(ENCRYPTOFFSET("0x105EB9280")); // ATUALIZADO 100%
    _set_aim_nepmods(player, look, false); // public void SetAimRotation(Quaternion JGOGIAFGCFC) { }
}

bool FW(void *instance) {
    if (FSWitch) {
        return false;
	}
}

Quaternion GetRotationToLocation(Vector3 targetLocation, float y_bias, Vector3 myLoc){
    return Quaternion::LookRotation((targetLocation + Vector3(0, y_bias, 0)) - myLoc, Vector3(0, 1, 0));
}


ImVec2 world2screen_i(Vector3 pos) {
    auto cam = get_camera();
    if (!cam) return {0,0};

    Vector3 worldPoint = WorldToViewpoint(cam,pos, 2);
    Vector3 location;

    int ScreenWidth = ImGui::GetIO().DisplaySize.x;
    int ScreenHeight = ImGui::GetIO().DisplaySize.y;

    location.x = ScreenWidth * worldPoint.x;
    location.y = ScreenHeight - worldPoint.y * ScreenHeight;
    location.z = worldPoint.z;

    return {location.x, location.y};
}

Vector3 world2screen_ii(Vector3 pos) {
    auto cam = get_camera();
    if (!cam) return {0,0};

    Vector3 worldPoint = WorldToViewpoint(cam,pos, 2);
    Vector3 location;

    int ScreenWidth = [UIScreen mainScreen].bounds.size.width;
    int ScreenHeight = [UIScreen mainScreen].bounds.size.height;

    location.x = ScreenWidth * worldPoint.x;
    location.y = ScreenHeight - worldPoint.y * ScreenHeight;
    location.z = worldPoint.z;

    return {location.x, location.y, location.z};
}

ImVec2 world2screen_c(Vector3 pos, bool &checker) {
    auto cam = get_camera();
    if (!cam) return {0,0};
   
    Vector3 worldPoint = WorldToViewpoint(cam,pos, 2);
    Vector3 location;
 
    int ScreenWidth = ImGui::GetIO().DisplaySize.x;
    int ScreenHeight = ImGui::GetIO().DisplaySize.y;
 
    location.x = ScreenWidth * worldPoint.x;
    location.y = ScreenHeight - worldPoint.y * ScreenHeight;
    location.z = worldPoint.z;
 
    checker = location.z > 1;
 
    return {location.x, location.y};
}


void DrawFilledRect(float x, float y, float width, float height, ImColor color) {
    ImGui::GetForegroundDrawList()->AddRectFilled(
        ImVec2(x, y),                       
        ImVec2(x + width, y + height),     
        ImGui::ColorConvertFloat4ToU32(color)
    );
}

// AIMKILL
struct COW_GamePlay_IHAAMHPPLMG_o {
    uint32_t NBPDJAAAFBH;
    uint32_t JEDDPHIHGKL;
    uint8_t IOICFFEKAIL;
    uint8_t PHAFNFOFFDB;
    uint64_t BNFAIDHEHOM;
};

struct DamageInfo2_o {
    void *klass;
    void *monitor;
    int32_t DBLBLKADCNP;
    int32_t KENBMOOEHBG;
    monoString* JANPNJIFOJJ;
    bool NNNADMOFPIE;
    COW_GamePlay_IHAAMHPPLMG_o DHGCIEKPBFA;
    void* GPBDEDFKJNA;
    int32_t PIAMIOFEBKF;
    Vector3 CNEICNJFGLM;
    Vector3 HECJHKEDFEB;
    Vector3 JNLGFLFLBHO;
    uint8_t ACAKHEABPEJ;
    bool MJIHLDJNHLF;
    int32_t LOKIMAEAPCB;
    Dictionary<uint8_t*, void **> *FHLFLAHCIBN;
};

struct HitObjectInfo {
    void *klass;
    void *monitor;
    bool m_IsInPool;
    void *HitObject;
    void *HitCollider;
    Vector3 HitLocation;
    Vector3 HitNormal;
    Vector3 RayDir;
    Vector3 StartPosition;
    int32_t Damage;
    float Distance;
    int32_t ActorLayer;
    int32_t HitGroup;
    void *HitPhysicMaterial;
    bool IgnoreHappens;
    bool ViewBlocked;
    struct Vector3 OrigStartPosition;
    uint8_t SpecialHitType;
    uint32_t SpecialHitLevelObjID;
};

// static monoString *CreateString(const char *str)
// {
//     return ((monoString * (*)(void *, const char *))getRealOffset(ENCRYPTOFFSET("0x106D0A22C")))(nullptr, str);
// }

bool Physics_Raycast(Vector3 OOFIJHADLNI, Vector3 CHGADBAMMOP, uint32_t ONEDHFJBCMJ, void **JEEIBOEGGPD)
{
    return ((bool (*)(Vector3, Vector3, uint32_t, void **))getRealOffset(ENCRYPTOFFSET("0x105E83118")))(OOFIJHADLNI, CHGADBAMMOP, ONEDHFJBCMJ, JEEIBOEGGPD);
}

Vector3 get_Position(void *player)
{
    return ((Vector3 (*)(void *))getRealOffset(ENCRYPTOFFSET("0x106DEAF94")))(player);
}

void *get_gameObject(void *player)
{
    return ((void *(*)(void *))getRealOffset(ENCRYPTOFFSET("0x106DA4E2C")))(player);
}

void *get_HeadCollider(void *player)
{
    return ((void *(*)(void *))getRealOffset(ENCRYPTOFFSET("0x105EB7BE4")))(player);
}

int GetTypeWeapon(void *player)
{
    return ((int (*)(void *))getRealOffset(ENCRYPTOFFSET("0x101C2B9D4")))(player);
}

void *GetHeadTF(void *player)
{
    return ((void* (*)(void*))getRealOffset(ENCRYPTOFFSET("0x105F2E67C")))(player);
}

void *GetWeaponOnHand(void *player)
{
    return ((void* (*)(void*))getRealOffset(ENCRYPTOFFSET("0x105EB44C0")))(player);
}

List<float *> *LCLHHHKFCFP(void *Weapon, void *CAGCICACKCF, void *HFBDJJDICLN, bool LDGHPOPPPNL, void *DamageInfo)
{
    return ((List<float *> * (*)(void*, void*, void*, bool, void*))getRealOffset(ENCRYPTOFFSET("0x101C4F034")))(Weapon, CAGCICACKCF, HFBDJJDICLN, LDGHPOPPPNL, DamageInfo);
}

void *GKHECDLGAJA(void *pthis, void* a1)
{
    return ((void* (*)(void *, void *))getRealOffset(ENCRYPTOFFSET("0x105F1456C")))(pthis, a1);
}

int32_t Player_TakeDamage(void *Player, int32_t p_damage, COW_GamePlay_IHAAMHPPLMG_o PlayerID, void *DamageInfo, int32_t WeaponDataID, Vector3 FirePos, Vector3 TargetPos, List<float *> *CheckParams, void *p_idk1, int32_t p_idk2)
{
    return ((int32_t (*)(void *, int32_t, COW_GamePlay_IHAAMHPPLMG_o, void *, int32_t, Vector3, Vector3, List<float *> *, void *, uint32_t))getRealOffset(ENCRYPTOFFSET("0x10604FD3C")))(Player, p_damage, PlayerID, DamageInfo, WeaponDataID, FirePos, TargetPos, CheckParams, p_idk1, p_idk2);
}

void SwapWeapon(void *Pthis, int32_t FANMJANBFIL, bool GDKLMFLNNGM)
{
    return ((void (*)(void *, int, bool, void*))getRealOffset(ENCRYPTOFFSET("0x105F20234")))(Pthis, FANMJANBFIL, GDKLMFLNNGM, nullptr);
}

bool isaimkill = false;
bool istelekill = false;
bool isfly = false;
bool isUndergroundKill = false;
bool isGoUnderground = false;

bool cameraAdjusted = false;
std::map<void*, float> enemyOriginalY;
float GoUndergroundDepth = -5.0f;


static int TimerTakeDamageinit = 0;
float maxDistanceAimkill = 100.0f; //padrao 100

bool isInsideFOV(int x, int y) {
    if (!enable_circleFov)
        return true;
    
    int circle_x = [UIScreen mainScreen].bounds.size.width / 2;
    int circle_y = [UIScreen mainScreen].bounds.size.height / 2;
    
    return (x - circle_x) * (x - circle_x) + (y - circle_y) * (y - circle_y) <= (int)AimFov * (int)AimFov;
}

void *GetClosestEnemy(void *match) {
    if (!match) {
        return NULL;
    }
    
    float shortestDistance = 99999;
    float maxAngle = AimFov;
    void *closestEnemy = NULL;
    void *LocalPlayer = GetLocalPlayer(match);
    
    if (LocalPlayer != nullptr) {
        Dictionary<uint8_t *, void **> *players = *(Dictionary<uint8_t *, void **> **)((long)match + 0xC8);
        
        if (players != nullptr && players->getNumValues() > 0) {
            for (int u = 0; u < players->getNumValues(); u++) {
                void *Player = players->getValues()[u];
                if (Player != NULL && !get_isLocalTeam(Player) && !get_IsDieing(Player) && get_MaxHP(Player)) {
                    Vector3 PlayerPos = GetHipPosition(Player);
                    Vector3 LocalPlayerPos = GetHeadPosition(LocalPlayer);
                    
                    float distance = Vector3::Distance(LocalPlayerPos, PlayerPos);
                    Vector3 targetDir = Vector3::Normalized(PlayerPos - LocalPlayerPos);
                    float angle = Vector3::Angle(targetDir, GetForward(Component_GetTransform(Camera_main()))) * 100.0;
                    
                    if (angle <= maxAngle) {
                        if (enable_circleFov) {
                            Vector3 ScreenPos = world2screen_ii(PlayerPos);
                            if (isInsideFOV(ScreenPos.x, ScreenPos.y)) {
                                if (distance < shortestDistance) {
                                    shortestDistance = distance;
                                    closestEnemy = Player;
                                }
                            }
                        } else {
                            if (distance < shortestDistance) {
                                shortestDistance = distance;
                                closestEnemy = Player;
                            }
                        }
                    }
                }
            }
        }
    }
    
    return closestEnemy;
}

void *GetClosestEnemyToAimkill(void *match) {
    if (!match) {
        return NULL;
    }
    
    float shortestDistance = 99999;
    void *closestEnemyToAimkill = NULL;
    void *LocalPlayer = GetLocalPlayer(match);
    
    if (LocalPlayer != nullptr) {
        Dictionary<uint8_t *, void **> *players = *(Dictionary<uint8_t *, void **> **)((long)match + 0xC8);
        
        if (players != nullptr && players->getNumValues() > 0) {
            for (int u = 0; u < players->getNumValues(); u++) {
                void *Player = players->getValues()[u];
                if (Player != NULL && !get_isLocalTeam(Player) && !get_IsDieing(Player) && get_MaxHP(Player)) {
                    Vector3 PlayerPos = GetHipPosition(Player);
                    Vector3 LocalPlayerPos = GetHeadPosition(LocalPlayer);
                    
                    float distance = Vector3::Distance(LocalPlayerPos, PlayerPos);
                    
                    if (!IsVisible(Player)) {
                        continue;
                    }
                    
                    if (distance < shortestDistance) {
                        shortestDistance = distance;
                        closestEnemyToAimkill = Player;
                    }
                }
            }
        }
    }
    
    return closestEnemyToAimkill;
}

void StartAimkill() {
    if (!isaimkill)
        return;

    void* current_Match = CurentMatch();
    if (!current_Match)
        return;

    void* local_player = GetLocalPlayer(current_Match);
    if (!local_player)
        return;

    Dictionary<uint8_t*, void**>* players = *(Dictionary<uint8_t*, void**>**)((uintptr_t)current_Match + 0xC8);
    if (!players)
        return;

    void* camera = Camera_main();
    if (!camera)
        return;

    ImDrawList* drawList = ImGui::GetBackgroundDrawList();
    ImVec2 screenCenter(ImGui::GetIO().DisplaySize.x / 2, 0);

    Vector3 PlayerCameraPosition = getPosition(camera);

    float maxDistance = maxDistanceAimkill;

    for (int u = 1; u < players->getNumValues(); u++) {
        void* enemy1 = players->getValues()[u];

        if (!enemy1)
            continue;

        void* closestEnemyToAimkill = GetClosestEnemyToAimkill(current_Match);
        if (!closestEnemyToAimkill)
            continue;

        void* weaponOnHand = GetWeaponOnHand(local_player);
        if (!weaponOnHand)
            continue;

        void* ObjectPool = *(void**)((uintptr_t)local_player + 0xC20);
        if (!ObjectPool)
            continue;

        void* weaponData = *(void**)((uint64_t)weaponOnHand + 0x90);
        if (!weaponData)
            continue;

        auto weaponDataID = *(int32_t*)((uint64_t)weaponData + 0xCC);
        auto baseDamage = *(int*)((uintptr_t)weaponOnHand + 0xA0);
        auto playerID = *(COW_GamePlay_IHAAMHPPLMG_o*)((uintptr_t)local_player + 0x2B0);

        void* HeadTFEnemy = GetHeadTF(closestEnemyToAimkill);
        void* HeadTFLocal = GetHeadTF(local_player);
        void* HeadColliderEnemy = get_HeadCollider(closestEnemyToAimkill);

        if (weaponDataID == -1 || baseDamage == 0 || !HeadTFEnemy || !HeadTFLocal || !HeadColliderEnemy)
            continue;

        Vector3 m_Head = get_Position(HeadTFEnemy);
        Vector3 m_HeadLocal = get_Position(HeadTFLocal);
        float distanceToEnemy = Vector3::Distance(m_HeadLocal, m_Head);

        if (distanceToEnemy > maxDistance)
            continue; 

        void* PlayerAttributes = *(void**)((uint64_t)local_player + 0x5E8);
        if (!PlayerAttributes)
            continue;

        void* DamageModule = *(void**)((uint64_t)PlayerAttributes + 0x288);
        if (!DamageModule)
            continue;

        void* DamageInfo = *(void**)((uint64_t)DamageModule + 0x10);
        if (!DamageInfo)
            continue;

      //  int maxWeapons = 3;
      //  if (rand() % 10 < 1) {
      //      SwapWeapon(local_player, rand() % maxWeapons, 1);
      //  }

        *(int*)((char*)DamageInfo + 0x10) = baseDamage;
        *(int*)((char*)DamageInfo + 0x14) = 1;
        *(void**)((char*)DamageInfo + 0x40) = weaponOnHand;
        *(int*)((char*)DamageInfo + 0x48) = weaponDataID;
        *(COW_GamePlay_IHAAMHPPLMG_o*)((char*)DamageInfo + 0x28) = playerID;

        *(void**)((uint64_t)ObjectPool + 0x18) = get_gameObject(HeadColliderEnemy);
        *(void**)((uint64_t)ObjectPool + 0x20) = HeadColliderEnemy;
        *(int*)((uint64_t)ObjectPool + 0x64) = 1;

        void* attackInstance = GKHECDLGAJA(local_player, ObjectPool);
        if (!attackInstance)
            continue;

        List<float*>* shotParams = LCLHHHKFCFP(weaponOnHand, attackInstance, HeadColliderEnemy, false, DamageInfo);
        TimerTakeDamageinit++;

        if (TimerTakeDamageinit % (rand() % 3 + 5) == 0) {
            int weaponType = GetTypeWeapon(weaponOnHand);
            if (weaponType == 3 && distanceToEnemy <= 3.0f) {
                ((void* (*)(void*, void*))getRealOffset(ENCRYPTOFFSET("0x106076B14")))(local_player, weaponOnHand);
                Player_TakeDamage(closestEnemyToAimkill, baseDamage, playerID, DamageInfo, weaponDataID, m_HeadLocal, m_Head, shotParams, shotParams, 0);
            } else {
                if (rand() % 10 >= 1) { // 15% de falha
                    ((void* (*)(void*, void*))getRealOffset(ENCRYPTOFFSET("0x106076B14")))(local_player, weaponOnHand);
                    Player_TakeDamage(closestEnemyToAimkill, baseDamage, playerID, DamageInfo, weaponDataID, m_HeadLocal, m_Head, shotParams, shotParams, 0);
                }
            }
        }

        if (TimerTakeDamageinit >= 15) {
            TimerTakeDamageinit = 0;
        }
    }
}

void RunTelekill() {
    if (!istelekill)
        return;

    void *match = CurentMatch();
    if (!match) return;

    void *local = GetLocalPlayer(match);
    if (!local || !Component_GetTransform(local)) return;

    Dictionary<uint8_t *, void **> *players = *(Dictionary<uint8_t *, void **> **)((long)match + 0xC8);
    if (!players || !players->getValues()) return;

    void *localTF = Component_GetTransform(local);
    Vector3 localPos = get_Position(localTF);
    Vector3 forward = GetForward(localTF);

    for (int i = 0; i < players->getNumValues(); i++) {
        void *enemy = players->getValues()[i];
        if (!enemy || enemy == local) continue;
        if (!Component_GetTransform(enemy)) continue;
        if (!get_MaxHP(enemy)) continue;
        if (get_IsDieing(enemy)) continue;
        if (GetHp(enemy) <= 0) continue;
        if (get_isLocalTeam(enemy)) continue;

        void *enemyTF = Component_GetTransform(enemy);
        Vector3 enemyPos = get_Position(enemyTF);
        float distance = Vector3::Distance(localPos, enemyPos);

        if (distance > 8.0f)
            continue;

        
        Vector3 stableFront = localPos + forward * 1.2f;
        stableFront.y = localPos.y; // 

        Transform_INTERNAL_SetPosition(enemyTF, Vvector3(stableFront.x, stableFront.y, stableFront.z));
    }
}

void RunUpPlayer() {
   if (!isfly)
        return;

    void *match = CurentMatch();
    if (!match) return;

    void *local = GetLocalPlayer(match);
    if (!local || !Component_GetTransform(local)) return;

    Dictionary<uint8_t *, void **> *players = *(Dictionary<uint8_t *, void **> **)((long)match + 0xC8);
    if (!players || !players->getValues()) return;

    for (int i = 0; i < players->getNumValues(); i++) {
        void *enemy = players->getValues()[i];
        if (!enemy || enemy == local) continue;
        if (!Component_GetTransform(enemy)) continue;
        if (!get_MaxHP(enemy)) continue;
        if (get_IsDieing(enemy)) continue;
        if (GetHp(enemy) <= 0) continue;
        if (get_isLocalTeam(enemy)) continue;

        void *enemyTF = Component_GetTransform(enemy);
        void *localTF = Component_GetTransform(local);
        if (!enemyTF || !localTF) continue;

        Vector3 enemyPos = get_Position(enemyTF);
        Vector3 localPos = get_Position(localTF);
        float distance = Vector3::Distance(localPos, enemyPos);

        float groundY = enemyPos.y;
        float targetY = groundY + 5.7f;

        float step = 0.90f;
        
        if (enemyPos.y < targetY - 0.1f)
            enemyPos.y += step;
       // else if (enemyPos.y > targetY + 0.1f)
       //     enemyPos.y -= step;

        Transform_INTERNAL_SetPosition(enemyTF, Vvector3(enemyPos.x, enemyPos.y, enemyPos.z));
    }
}

void RunUndergroundKill() {
    if (!isUndergroundKill)
        return;

    isfly = false;

    void *match = CurentMatch();
    if (!match) return;

    void *local = GetLocalPlayer(match);
    if (!local || !Component_GetTransform(local)) return;

    void *camTF = Component_GetTransform(Camera_main());
    if (camTF && !cameraAdjusted) {
        Vector3 camPos = get_position(camTF);
        camPos.y -= 5.0f; 
        Transform_INTERNAL_SetPosition(camTF, Vvector3(camPos.x, camPos.y, camPos.z));
        cameraAdjusted = true;
    }

    Dictionary<uint8_t *, void **> *players = *(Dictionary<uint8_t *, void **> **)((long)match + 0xC8);
    if (!players || !players->getValues()) return;

    for (int i = 0; i < players->getNumValues(); i++) {
        void *enemy = players->getValues()[i];
        if (!enemy || enemy == local) continue;
        if (!Component_GetTransform(enemy)) continue;
        if (!get_MaxHP(enemy)) continue;
        if (get_IsDieing(enemy)) continue;
        if (GetHp(enemy) <= 0) continue;
        if (get_isLocalTeam(enemy)) continue;

        void *enemyTF = Component_GetTransform(enemy);
        Vector3 enemyPos = get_Position(enemyTF);

        if (enemyOriginalY.find(enemy) == enemyOriginalY.end()) {
            enemyOriginalY[enemy] = enemyPos.y;
        }

        float targetY = enemyOriginalY[enemy] - 2.0f;
        if (abs(enemyPos.y - targetY) > 0.1f) {
            enemyPos.y = targetY;
            Transform_INTERNAL_SetPosition(enemyTF, Vvector3(enemyPos.x, enemyPos.y, enemyPos.z));
        }
    }
}

void RunGoUnderground() {
    if (!isGoUnderground)
        return;

    void *match = CurentMatch();
    if (!match) return;

    void *local = GetLocalPlayer(match);
    if (!local || !Component_GetTransform(local)) return;

    void *localTF = Component_GetTransform(local);
    static float storedX = 0, storedZ = 0;

    Vector3 currentPos = get_Position(localTF);

    float yOffset = GoUndergroundDepth;
    if (yOffset < -5.0f) yOffset = -5.0f;
    if (yOffset > -1.0f) yOffset = -1.0f;

    if (storedX == 0 && storedZ == 0) {
        storedX = currentPos.x;
        storedZ = currentPos.z;
    }

    Vector3 floatPos(storedX, currentPos.y + yOffset, storedZ);
    Transform_INTERNAL_SetPosition(localTF, Vvector3(floatPos.x, floatPos.y, floatPos.z));
}

void DrawEsp() {
ImDrawList* drawList = ImGui::GetBackgroundDrawList();
if (Crosshair) {
    ImVec2 center = ImGui::GetMainViewport()->GetCenter();
    float size = ImGui::GetMainViewport()->Size.x * 0.03f; 
    float halfSize = size * 0.5f;
    ImVec2 horizontalStart(center.x - halfSize, center.y);
    ImVec2 horizontalEnd(center.x + halfSize, center.y);
    ImVec2 verticalStart(center.x, center.y - halfSize);
    ImVec2 verticalEnd(center.x, center.y + halfSize);
    ImGui::GetBackgroundDrawList()->AddLine(horizontalStart, horizontalEnd, IM_COL32(255, 255, 255, 255));
    ImGui::GetBackgroundDrawList()->AddLine(verticalStart, verticalEnd, IM_COL32(255, 255, 255, 255));
}

if (ESPEnable) {
   // std::this_thread::sleep_for(std::chrono::milliseconds(100));
    void *current_Match = CurentMatch();
    void *local_player = GetLocalPlayer(current_Match);
    if (local_player != nullptr && current_Match != nullptr) {
        Dictionary<uint8_t *, void **> *players = *(Dictionary<uint8_t*, void **> **)((long)current_Match + 0xC8); // ATUALIZADO
        void *camera = Camera_main();
        if (players != nullptr && camera != nullptr) {
            for (int u = 0; u < players->getNumValues(); u++) {
                void *ClosestEnemy = players->getValues()[u];
                if (ClosestEnemy != local_player && ClosestEnemy != nullptr && get_isVisible(ClosestEnemy) && !get_isLocalTeam(ClosestEnemy) && get_MaxHP(ClosestEnemy)) {
                    ImVec2 enemyPos = world2screen_i(GetPlayerLocation(ClosestEnemy));
                    Vector3 pos = getPosition(ClosestEnemy);
                    Vector3 viewpos = getPosition(local_player);
                    float distance = Vector3::Distance(viewpos, pos);
                    int health = GetHp(ClosestEnemy); 
                    int maxhp = get_MaxHP(ClosestEnemy);
                    if (distance > 200.0f) continue;

                    bool w2sCheck = false;

                    ImVec2 top_pos = world2screen_i(pos + Vector3(0, 1.5f, 0));
                    ImVec2 bot_pos = world2screen_i(pos + Vector3(0, -0.15f, 0)); 

                    world2screen_c(pos + Vector3(0, 0.75f, 0), w2sCheck);  
                    if (!w2sCheck) continue;  

                    float boxHeight = fabs(top_pos.y - bot_pos.y);
                    float boxWidth = boxHeight * 0.75f;

                    if (boxHeight <= 0 || boxWidth <= 0) continue;

                    ImRect rect(ImVec2(bot_pos.x - boxWidth / 2, top_pos.y), ImVec2(bot_pos.x + boxWidth / 2, bot_pos.y));

if (ESPBox) {
    float borderThickness = 1.0f;
    ImColor boxColor = IsVisible(ClosestEnemy) 
        ? ImColor(colorVisible[0], colorVisible[1], colorVisible[2], colorVisible[3]) 
        : ImColor(colorInvisible[0], colorInvisible[1], colorInvisible[2], colorInvisible[3]);

    float adjustedWidth = (rect.Max.x - rect.Min.x) * 0.75f;
    ImVec2 adjustedMin(rect.Min.x + (rect.Max.x - rect.Min.x - adjustedWidth) / 2, rect.Min.y);
    ImVec2 adjustedMax(adjustedMin.x + adjustedWidth, rect.Max.y);

    if (ESPBoxShape == 0 || ESPBoxShape == 1) {
        float cornerRadius = (ESPBoxShape == 0) ? 2.0f : 0.0f;
        drawList->AddRect(adjustedMin, adjustedMax, boxColor, cornerRadius, 0, borderThickness);
    } else if (ESPBoxShape == 2) {
        float boxWidth = adjustedMax.x - adjustedMin.x;
        float boxHeight = adjustedMax.y - adjustedMin.y;

        const float defaultLineLength = 6.0f;
        const float minGapBetweenCorners = 4.0f;

        float maxLineLengthX = (boxWidth - minGapBetweenCorners) / 2.0f;
        float lineLengthX = (defaultLineLength < maxLineLengthX) ? defaultLineLength : maxLineLengthX;

        float maxLineLengthY = (boxHeight - minGapBetweenCorners) / 2.0f;
        float lineLengthY = (defaultLineLength < maxLineLengthY) ? defaultLineLength : maxLineLengthY;

        ImVec2 topLeft     = adjustedMin;
        ImVec2 topRight    = ImVec2(adjustedMax.x, adjustedMin.y);
        ImVec2 bottomLeft  = ImVec2(adjustedMin.x, adjustedMax.y);
        ImVec2 bottomRight = adjustedMax;

        drawList->AddLine(topLeft, ImVec2(topLeft.x + lineLengthX, topLeft.y), boxColor, borderThickness);
        drawList->AddLine(topLeft, ImVec2(topLeft.x, topLeft.y + lineLengthY), boxColor, borderThickness);

        drawList->AddLine(topRight, ImVec2(topRight.x - lineLengthX, topRight.y), boxColor, borderThickness);
        drawList->AddLine(topRight, ImVec2(topRight.x, topRight.y + lineLengthY), boxColor, borderThickness);

        drawList->AddLine(bottomLeft, ImVec2(bottomLeft.x + lineLengthX, bottomLeft.y), boxColor, borderThickness);
        drawList->AddLine(bottomLeft, ImVec2(bottomLeft.x, bottomLeft.y - lineLengthY), boxColor, borderThickness);

        drawList->AddLine(bottomRight, ImVec2(bottomRight.x - lineLengthX, bottomRight.y), boxColor, borderThickness);
        drawList->AddLine(bottomRight, ImVec2(bottomRight.x, bottomRight.y - lineLengthY), boxColor, borderThickness);
    }
}

if (ESPHealth) { 
    float healthPercentage = (float)health / maxhp;

    float healthBarHeight = rect.Max.y - rect.Min.y; 
    float healthBarWidth = 4.0f; 

    ImVec2 barPos;
    if (ESPHealthPosition == 0) {
        barPos = ImVec2(rect.Min.x - healthBarWidth - 2.0f, rect.Min.y);
    } else {
        barPos = ImVec2(rect.Max.x + 1.7f, rect.Min.y);
    }

    ImVec2 barSize(healthBarWidth, healthBarHeight);

    float filledHeight = healthBarHeight * healthPercentage;
    ImVec2 filledBarPos = ImVec2(barPos.x, barPos.y + (healthBarHeight - filledHeight)); 

    ImColor healthColor;
    if (health >= 100) {
        healthColor = ImColor(0, 255, 0); 
    } else if (health >= 50) {
        healthColor = ImColor(255, 255, 0); 
    } else {
        healthColor = ImColor(255, 0, 0); 
    }

    drawList->AddRectFilled(filledBarPos, ImVec2(filledBarPos.x + healthBarWidth, filledBarPos.y + filledHeight), healthColor, 4.0f);

    drawList->AddRect(barPos, ImVec2(barPos.x + healthBarWidth, barPos.y + healthBarHeight), ImColor(0, 0, 0), 4.0f); 
}


if (ESPSkeleton) { 
    Vector3 head = GetHeadPosition(ClosestEnemy);
    Vector3 hip = GetHipPosition(ClosestEnemy);
    Vector3 neck = head - Vector3(0, 0.15f, 0); 
    Vector3 leftShoulder = GetLeftShoulderPosition(ClosestEnemy);
    Vector3 rightShoulder = GetRightShoulderPosition(ClosestEnemy);
    Vector3 leftHand = GetLeftHandPosition(ClosestEnemy);
    Vector3 rightHand = GetRightHandPosition(ClosestEnemy);
    Vector3 leftForeArm = GetLeftForeArmPosition(ClosestEnemy);
    Vector3 rightForeArm = GetRightForeArmPosition(ClosestEnemy);
    Vector3 leftAnkle = GetLeftAnklePosition(ClosestEnemy);
    Vector3 rightAnkle = GetRightAnklePosition(ClosestEnemy);
    Vector3 leftToe = GetLeftToePosition(ClosestEnemy);
    Vector3 rightToe = GetRightToePosition(ClosestEnemy);

    ImColor skeletonColor = IsVisible(ClosestEnemy) 
        ? ImColor(colorVisible[0], colorVisible[1], colorVisible[2], colorVisible[3]) 
        : ImColor(colorInvisible[0], colorInvisible[1], colorInvisible[2], colorInvisible[3]);

    ImVec2 screenHead = world2screen_i(head);
    ImVec2 screenNeck = world2screen_i(neck);
    ImVec2 screenHip = world2screen_i(hip);
    ImVec2 screenLeftShoulder = world2screen_i(leftShoulder);
    ImVec2 screenRightShoulder = world2screen_i(rightShoulder);
    ImVec2 screenLeftHand = world2screen_i(leftHand);
    ImVec2 screenRightHand = world2screen_i(rightHand);
    ImVec2 screenLeftForeArm = world2screen_i(leftForeArm);
    ImVec2 screenRightForeArm = world2screen_i(rightForeArm);
    ImVec2 screenLeftAnkle = world2screen_i(leftAnkle);
    ImVec2 screenRightAnkle = world2screen_i(rightAnkle);
    ImVec2 screenLeftToe = world2screen_i(leftToe);
    ImVec2 screenRightToe = world2screen_i(rightToe);

    drawList->AddLine(screenHead, screenNeck, skeletonColor, 1.0f);

    float headRadius = Vector3::Distance(head, neck) * 0.5f; 
    drawList->AddCircle(screenHead, headRadius, skeletonColor, 12, 1.0f);

    float neckRadius = headRadius * 0.6f;
    drawList->AddCircle(screenNeck, neckRadius, skeletonColor, 12, 1.0f);

    drawList->AddLine(screenNeck, screenHip, skeletonColor, 1.0f);

    drawList->AddLine(screenNeck, screenLeftShoulder, skeletonColor, 1.0f); 
    drawList->AddLine(screenNeck, screenRightShoulder, skeletonColor, 1.0f); 
    drawList->AddLine(screenLeftShoulder, screenLeftForeArm, skeletonColor, 1.0f); 
    drawList->AddLine(screenRightShoulder, screenRightForeArm, skeletonColor, 1.0f); 
    drawList->AddLine(screenLeftForeArm, screenLeftHand, skeletonColor, 1.0f);
    drawList->AddLine(screenRightForeArm, screenRightHand, skeletonColor, 1.0f); 
    drawList->AddLine(screenHip, screenLeftAnkle, skeletonColor, 1.0f); 
    drawList->AddLine(screenHip, screenRightAnkle, skeletonColor, 1.0f); 
    drawList->AddLine(screenLeftAnkle, screenLeftToe, skeletonColor, 1.0f); 
    drawList->AddLine(screenRightAnkle, screenRightToe, skeletonColor, 1.0f); 
}

if (ESPName) {
    std::string nickname = IsClientBot(ClosestEnemy) ? ENCRYPT("BOT") : getPlayerNickname(ClosestEnemy);
    ImVec2 nicknameWidth = _espFont->CalcTextSizeA(10.0f, MAXFLOAT, 0.0f, nickname.c_str());

    ImColor textColor = IsVisible(ClosestEnemy)
        ? ImColor(colorVisible[0], colorVisible[1], colorVisible[2], colorVisible[3])
        : ImColor(colorInvisible[0], colorInvisible[1], colorInvisible[2], colorInvisible[3]);

    if (ESPNameShadow == 0) {
        ImVec2 rectMin = ImVec2(top_pos.x - (nicknameWidth.x / 2.0f) - 4, top_pos.y - 12);
        ImVec2 rectMax = ImVec2(top_pos.x + (nicknameWidth.x / 2.0f) + 4, top_pos.y);
        drawList->AddRectFilled(rectMin, rectMax, ImColor(0, 0, 0, 170), 2.0f);

        DrawText2(_espFont, 10.0f,
            ImVec2(top_pos.x - (nicknameWidth.x / 2.0f), top_pos.y - 10),
            textColor,
            nickname.c_str(),
            ImColor(0, 0, 0, 0));
    }
    else {
        DrawText2(_espFont, 10.0f,
            ImVec2(top_pos.x - (nicknameWidth.x / 2.0f), top_pos.y - 10),
            textColor,
            nickname.c_str(),
            ImColor(0, 0, 0, 0));
    }
}

if (ESPL) {
    espActivationCount++;

    ImColor lineColor = IsVisible(ClosestEnemy)
        ? ImColor(colorVisible[0], colorVisible[1], colorVisible[2], colorVisible[3])
        : ImColor(colorInvisible[0], colorInvisible[1], colorInvisible[2], colorInvisible[3]);

    Vector3 head = GetHeadPosition(ClosestEnemy);
    ImVec2 screenHead = world2screen_i(head);

    ImVec2 startPoint;

    switch (ESPLinePosition) {
        case 0: // PERFEITO
            startPoint = ImVec2(kWidth / 2, 0);
            break;
        case 1: // PERFEITO
            startPoint = ImVec2(kWidth / 2, (float)kHeight);
            break;
        case 2: // PERFEITO
            startPoint = ImVec2(kWidth / 2, (float)(kHeight / 2));
            break;
        default:
            startPoint = ImVec2(kWidth / 2, 0);
            break;
    }

    RenderLine(startPoint, ImVec2(screenHead.x, screenHead.y), lineColor, 0.9f);

                    }
                }
            }
        }
    }
}
}

